standardFont = "fonts/centurygothic.mvec";
proportionalFont = "fonts/default.mvec";

eClosetVisits = 0;
eCustomizeVisits = 1;
eMyWaiterMainMenuVisits = 2;
eMyWaiterMPVisits = 3;
eMyDinerMainMenuVisits = 4;
eMyDinerMPVisits = 5;
eMyDinerMapVisits = 6;
eMyDinerTakeSnapshot = 7;
eMyDinerPlay = 8;
eMyDinerShare = 9;
eMyDinerGallery = 10;
eMPRematchEvent = 11;
eMPRematchAcceptEvent = 12;

kScreenDeactivate = 1000;
kGameQuitEarly = 1001;
kClothingChanged = 1002;
kGameMsg = 1003;
kNewContentAvailable = 1004;
kMyDinerChanged = 1005;
kPlayerLoggedIn = 1006;
kSliderPageUp = 11;
kSliderPageDown = 12;


kSpriteWindowDefaultDraw = 0;
kSpriteWindowFlipHorizontal = 1;
kSpriteWindowFlipVertical = 2;

kPopupDialogTopY = 25;
kPopupDialogH = 230;
kLongDialogX = 27;
kLongDialogW = 350;

BlackColor = Color(0,0,0,255);
BlueColor = Color(16,225,226,255);
YellowColor = Color(255,255,0,255);
WhiteColor = Color(255,255,255,255);
PurpleColor = Color(255,0,255,255);
RedColor = Color(163,11,11,255);
GreenColor = Color(34,253,26,255);
BorderColor = Color(0,0,0,255);
DarkGreenColor = Color(9,106,9,255);
DarkBlueColor = Color(0,0,106,255);
DarkGray = Color(50,50,50,255);



StandardButtonGraphics = {
	"buttons/menu_button4a",
	"buttons/menu_button4b",
	"buttons/menu_button4c",
};

ClosetButtonGraphics = {
	"floscloset/ui/my_waiter_button_a",
	"floscloset/ui/my_waiter_button_b",
	"floscloset/ui/my_waiter_button_c"
};


ClosetArrowLeftButtonGraphics = {
	"floscloset/ui/left_arrow_a",
	"floscloset/ui/left_arrow_b",
	"floscloset/ui/left_arrow_a"
};


LargeButtonGraphics = {
	"buttons/menu_button5a",
	"buttons/menu_button5b",
	"buttons/menu_button5c"
};

SolidButtonGraphics = {
	"buttons/map_button_a",
	"buttons/map_button_b",
	"buttons/map_button_c"
};



CheckboxButtonGraphics = {
	"buttons/checkbox_a",
	"buttons/checkbox_b",
	"buttons/checkbox_a",
	"buttons/checkbox_b"
};

RadioButtonGraphics = {
	"buttons/radio_b",
	"buttons/radio_a",
	"buttons/radio_b",
	"buttons/radio_a"
};

LeftArrowGraphics = {
	"buttons/left_arrow_a.png",
	"buttons/left_arrow_b.png",
	"buttons/left_arrow_c.png"
};


UpArrowGraphics = {
	"buttons/arrowup_a.png",
	"buttons/arrowup_b.png",
	"buttons/arrowup_c.png"
};


MainMenuQuitGraphics = {
	"menu/menu_buttonMainquit-a",
	"menu/menu_buttonMainquit-b",
	"menu/menu_buttonMainquit-c"
};

MainMenuButton1Graphics = {
	"menu/menu_button_1-a",
	"menu/menu_button_1-b",
	"menu/menu_button_1-c"
};
MainMenuButton2Graphics = {
	"buttons/menu_button2a",
	"buttons/menu_button2b",
	"buttons/menu_button2c"
};

ChangePlayerButtonGraphics = {
	"menu/menu_button_changeu-a",
	"menu/menu_button_changeu-b",
	"menu/menu_button_changeu-c"
};
MainMenuButton4Graphics = {
	"buttons/menu_button4a",
	"buttons/menu_button4b",
	"buttons/menu_button4c"
};
MainMenuButton5Graphics = {
	"buttons/menu_button5a",
	"buttons/menu_button5b",
	"buttons/menu_button5c"
};
MainMenuButton6Graphics = {
	"buttons/menu_button6a",
	"buttons/menu_button6b",
	"buttons/menu_button6c"
};
MainMenuButton7Graphics = {
	"buttons/menu_button7a",
	"buttons/menu_button7b",
	"buttons/menu_button7c"
};



MPPlayButtonGraphics = {
	"menu/mpmenu/menu_button_play1-a",
	"menu/mpmenu/menu_button_play1-b",
	"menu/mpmenu/menu_button_play1-c"
};

MPPlayButtonFont = {
	standardFont,
	30,
	BlackColor
};




ComicLeftButtonGraphics = LeftArrowGraphics;


MenuButton1Font = {
	standardFont,
	14,
	BlackColor
};

MainMenuQuitFont = {
	standardFont,
	14,
	BlackColor
};


MenuButton2Font = {
	standardFont,
	14,
	BlackColor
};

ChangePlayerButtonFont = {
	standardFont,
	14,
	BlackColor
};

MenuButton4Font = {
	standardFont,
	18,
	BlackColor
};

MenuButton5Font = {
	standardFont,
	18,
	BlackColor
};

MenuButton6Font = {
	standardFont,
	18,
	BlackColor
};

MenuButton7Font = {
	standardFont,
	18,
	BlackColor
};


MenuNewFont = {
	standardFont,
	12,
	BlackColor
};



LargeButtonFont = {
  standardFont,
  18,
  BorderColor
};

StandardButtonFont = {
  standardFont,
  16,
  BorderColor
};

StandardBorderButtonFont = {
  standardFont,
  16,
  BorderColor
};

SmallestButtonFont = {
  standardFont,
  12,
  BorderColor
};

SmallButtonFont = {
  standardFont,
  14,
  BorderColor
};

SmallBorderButtonFont = {
  standardFont,
  14,
  BorderColor
};

DialogTitleFont = {
  standardFont,
  18,
  BorderColor
};


DialogBodyFont = {
  standardFont,
  18,
  BorderColor
};

OKBodyFont = {
  standardFont,
  24,
  BorderColor
};

LoadingDialogFont = {
  standardFont,
  30,
  BorderColor
};

ChatFont = {
  standardFont,
  14,
  BorderColor
};

ChatTOSFont = {
  standardFont,
  10,
  BorderColor
};




-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function MyCreateButton( button, factory )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");
			
			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers ) 
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; } 
			);

			table.insert(button,
				Text
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags ,
					factory=textfactory,
				}
			)
		end

		-- Creation function for generic window types
		button.create=GenericCreate;

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename=factory;
		DoWindow( button )
	end
end

function Button ( button )
	return MyCreateButton(button, 'TextDropButton');
end


kDefaultButtonSound="audio/sfx/menu_click.ogg";
kDefaultRolloverButtonSound="audio/sfx/menu_rollover.ogg";
DefaultStyle = {
	sound = kDefaultButtonSound,
	rolloversound = kDefaultRolloverButtonSound,
	xoffset = -1,
	yoffset = 1,
	padding = 3,
	ignore='<\n\\',
	fit=true,
	tx = 0, ty = 0,
	tw = kMax, th = kMax,
	font = {standardFont, 14, BlackColor},
};

MPPlayButtonStyle =
{
	parent = DefaultStyle,
	type = kPush,
	font = MPPlayButtonFont,
	graphics = MPPlayButtonGraphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};



ComicStyle = {
	translate = true,
	disableAbort = true,
	allowInput = true
};

MPButtonStyle =
{
	parent = DefaultStyle,
	type = kPush,
	font = StandardButtonFont,
	padding=0,
	graphics = SolidButtonGraphics,
	tx=10, ty=10, tw=kMax-10, th=kMax-10,
	flags=kHAlignCenter+kVAlignCenter
};

HelpArrowStyle =
{
	parent = DefaultStyle,
	type = kPush,
	graphics = LeftArrowGraphics,
	scale = 0.6
};



SliderStyle = 
{
	parent=DefaultStyle,
	railtop = "buttons/sliderrailtop",
	railmid = "buttons/sliderrailmid",
	railbot = "buttons/sliderrailbot",
	sliderimage = "buttons/sliderknob",
	sliderrollimage = "buttons/sliderknobover",
	yoffset = 0
};

WideSliderStyle = 
{
	parent=DefaultStyle,
	railtop = "buttons/wide_sliderrailtop",
	railmid = "buttons/wide_sliderrailmid",
	railbot = "buttons/wide_sliderrailbot",
	sliderimage = "buttons/wide_sliderknob",
	sliderrollimage = "buttons/wide_sliderknobover",
	yoffset = 0
};

ChatScrollStyle = 
{
	parent=DefaultStyle,
	railtop = "multi/scrollbar_top",
	railmid = "multi/scrollbar_mid",
	railbot = "multi/scrollbar_bot",
	sliderimage = "multi/scrollbar_knob",
	sliderrollimage = "multi/scrollbar_knobover",
	yoffset = 0,
	hslider = false
};

ChatScrollArrowStyle = 
{
	parent=DefaultStyle,
	graphics = {"multi/scrollbar_arrow_a","multi/scrollbar_arrow_b","multi/scrollbar_arrow_a"},
};

ScrolledWindowStyle=
{
	parent= SliderStyle,
	hslider = false,
	flags=kHAlignLeft+kVAlignTop,
};

ClosetButtonStyle =
{
	parent=DefaultStyle,
	font=SmallButtonFont,
	graphics=ClosetButtonGraphics,
	type = kPush,
	xoffset = 2,
	yoffset = 2,
};

ClosetArrowLeftButtonStyle =
{
	parent=DefaultStyle,
	font=SmallButtonFont,
	graphics={'floscloset/ui/left_arrow_a','floscloset/ui/left_arrow_b','floscloset/ui/left_arrow_a'},
	type = kPush,
};

ClosetArrowRightButtonStyle =
{
	parent=DefaultStyle,
	font=SmallButtonFont,
	graphics={'floscloset/ui/left_arrow_a','floscloset/ui/left_arrow_b','floscloset/ui/left_arrow_a'},
	type = kPush,
	hflip = true,
};
DifficultyButtonStyle =
{
	parent=DefaultStyle,
	scale=0.7,
	font={
	  standardFont,
	  20,
	  BorderColor
	},
	th = kMax - 4,
	graphics=StandardButtonGraphics,
	type = kPush
};

DifficultyApplyButtonStyle =
{
	parent=DefaultStyle,
	scale=0.8,
	font={
	  standardFont,
	  22,
	  BorderColor
	},
	th = kMax - 4,
	graphics=StandardButtonGraphics,
	type = kPush
};

SmallButtonStyle =
{
	parent=DefaultStyle,
	scale=0.8,
	font=SmallButtonFont,
	th = kMax - 4,
	graphics=StandardButtonGraphics,
	type = kPush
};

SmallestButtonStyle =
{
	parent=DefaultStyle,
	scale=0.6,
	font=SmallButtonFont,
	graphics=StandardButtonGraphics,
	th = kMax - 4,
	type = kPush
};

StandardButtonStyle =
{
	parent=DefaultStyle,
	font=StandardButtonFont,
	graphics=StandardButtonGraphics,
	th = kMax - 6,
	type = kPush
};

LargeButtonStyle =
{
	parent=DefaultStyle,
	font=StandardButtonFont,
	graphics=LargeButtonGraphics,
	th = kMax - 6,
	type = kPush
};

CheckboxButtonStyle =
{
	parent=DefaultStyle,
	font=StandardButtonFont,
	graphics=CheckboxButtonGraphics,
	type = kToggle,
	w=200,
	tx = 40,
	ty = 10,
	flags=kHAlignLeft+kVAlignCenter,
};

SolidButtonStyle =
{
	parent=DefaultStyle,
	font=StandardBorderButtonFont,
	graphics=SolidButtonGraphics,
	xoffset = 0,
	yoffset = 0,
	type = kPush
};

RadioButtonStyle =
{
	parent=DefaultStyle,
	font=StandardBorderButtonFont,
	graphics=RadioButtonGraphics,
	xoffset = 0,
	yoffset = 0,
	tx = 30,
	type = kRadio
};

MainMenuButtonStyle1 =
{
	parent = DefaultStyle,
	type = kPush,
	font = MenuButton1Font,
	graphics = MainMenuButton1Graphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};

MainMenuQuitStyle =
{
	parent = DefaultStyle,
	type = kPush,
	font = MainMenuQuitFont,
	graphics = MainMenuQuitGraphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};



MainMenuButtonStyle2 =
{
	parent = DefaultStyle,
	type = kPush,
	font = MenuButton2Font,
	graphics = MainMenuButton2Graphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};

ChangePlayerButtonStyle =
{
	parent = DefaultStyle,
	type = kPush,
	font = ChangePlayerButtonFont,
	graphics = ChangePlayerButtonGraphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};

MainMenuButtonStyle4 =
{
	parent = DefaultStyle,
	type = kPush,
	font = MenuButton4Font,
	graphics = MainMenuButton4Graphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};

MainMenuButtonStyle5 =
{
	parent = DefaultStyle,
	type = kPush,
	font = MenuButton5Font,
	graphics = MainMenuButton5Graphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};

MainMenuButtonStyle6 =
{
	parent = DefaultStyle,
	type = kPush,
	font = MenuButton6Font,
	graphics = MainMenuButton6Graphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};


MainMenuButtonStyle7 =
{
	parent = DefaultStyle,
	type = kPush,
	font = MenuButton7Font,
	graphics = MainMenuButton7Graphics,
	th = kMax - 5,
	xoffset = 0,
	yoffset = 2
};

MainMenuNewStyle =
{
	parent = DefaultStyle,
	font = MenuNewFont,
	image = "menu/new_label",
	label = "menu_new",
	flags = kHAlignCenter + kVAlignCenter
	
};


SetDefaultStyle(DefaultStyle);

kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:- \t";
kIllegalLoginChars = "!#$%^&*()><\\\"\'[]{}|?/+=~`,;:- \t";
kMaxUserNameLength = 20;
kMaxMyDinerNameLength = 30;
kMaxPFPasswordLength = 20;
kMaxPFUsernameLength = 200;

kDisableFade = 0.5;


FullScreenDialog=
{
	x=36,y=99,
	w=724,h=453,
	b=49,r=42,
};

LargeDialog=
{
	x=12,y=62,
	w=358,h=456,
	b=15,r=18
};

SmallDialog=
{
	x=12,y=62,
	w=267,h=171,
	b=16,r=15
};

MediumDialog=
{
	x=18,y=62,
	w=370,h=249,
	r=16,b=17
};

